// Copyright (c) 1998-2005 B2C2, Incorporated.  All Rights Reserved.
//
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF B2C2, INCORPORATED.
// The copyright notice above does not evidence any
// actual or intended publication of such source code.
//
// This file is proprietary source code of B2C2, Incorporated. and is released pursuant to and
// subject to the restrictions of the non-disclosure agreement and license contract entered
// into by the parties.
//
//
// AVPlaybackCtrl.h: interface for the CAVPlaybackCtrl class.
//
//////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_AVPLAYBACKCTRL_H__7C0F2517_B18A_47C0_8DB7_806C674FE555__INCLUDED_)
#define AFX_AVPLAYBACKCTRL_H__7C0F2517_B18A_47C0_8DB7_806C674FE555__INCLUDED_

#include "ib2c2mpeg2timeshiftctrl.h"
#include "b2filtergraphhandler.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


class CB2FilterGraphHandler;

//////////////////////////////////////////////////////////////////////////////
class CAVPlaybackCtrl 
{
public: // Construction/Destruction
	CAVPlaybackCtrl();
	virtual ~CAVPlaybackCtrl();

private: // Definitions
	enum E_STATE
	{
		STATE_UNKNOWN = 0,
		STATE_INITIALIZING,
		STATE_LIVE_PLAY,
		STATE_LIVE_RECORD,
		STATE_LIVE_PAUSE,
		STATE_FILE_PAUSE,
		STATE_STOP,
		STATE_TIMESHIFT_PLAY,
		STATE_TIMESHIFT_PAUSE,
	};


public: // Interface
	inline BOOL IsPlaying() const		{ return m_eState == STATE_LIVE_PLAY; };
	inline BOOL IsLivePause() const		{ return m_eState == STATE_LIVE_PAUSE; };
	inline BOOL IsTimeShiftPause() const{ return m_eState == STATE_TIMESHIFT_PAUSE; };
	inline BOOL IsStopped() const		{ return m_eState == STATE_STOP; };
	inline BOOL IsTimeShiftPlay() const	{ return m_eState == STATE_TIMESHIFT_PLAY; };
	inline BOOL IsLiveRecording() const		{ return m_eState == STATE_LIVE_RECORD; };

	BOOL IsStopEnabled();
	BOOL IsPauseEnabled();
	BOOL IsJumpToStartEnabled();
	BOOL IsRecordEnabled();

	inline LPCTSTR GetRecordPathName() const	{ return m_cstrRecordPathName; };

	inline __int64 GetPlaybackFilePosition() const 	{ return m_i64PlaybackFilePosition; };
	inline __int64 GetRecordFileSize() const 	{ return m_i64RecordFileSize; };

public: // Methods

	void Play();
	void Pause();
	void Stop();
	void Record( void);

	void JumpToStart( void );
	void JumpToEnd( void );
	void RepositionSliderBar( int iPositionPercentage );

	void GenerateTimeStampedFilename( CString* pcsRecordPathName, char* szPath, char* szRootNam );

	void GetStatistics();

	BOOL UpdateVideoSize(HWND hVideoWnd);

	void CheckTimeshiftStateChange();

	BOOL Initialize(HWND hVideoWnd );
	void Release();


	inline void PassB2FilterGraphHandler(CB2FilterGraphHandler* pB2FilterGraph)
	{
		m_pB2FilterGraph = pB2FilterGraph;
	}

	inline void PassAudioVideoPID(int iAudioPID, int iVideoPID)
	{
		m_iAudioPID = iAudioPID;
		m_iVideoPID = iVideoPID;
	};
	inline void PassAutoDeleteTimeshift(BOOL bAutoDeleteTimeshift)
	{
		m_bAutoDeleteTimeshift = bAutoDeleteTimeshift;
	};
	inline void PassAutoStartTimeshift(BOOL bAutoStartTimeshift)
	{
		m_bAutoStartTimeshift = bAutoStartTimeshift;
	};

	static UINT __stdcall CAVPlaybackCtrl::UpdatePvrState ( E_PVR_CALLBACK_STATE eCommand );

private: // Members variables

	CB2FilterGraphHandler* m_pB2FilterGraph;

	E_STATE	m_eState;

	static E_PVR_CALLBACK_STATE m_ePvrStateChange;

	__int64 m_i64RecordFileSize;
	__int64 m_i64PlaybackFilePosition;

	CString m_cstrRecordPathName;

	long m_alPids[PVR_PIDS_MAX];
	long m_lPids;

	int m_iAudioPID;
	int m_iVideoPID;
	BOOL m_bAutoDeleteTimeshift;
	BOOL m_bAutoStartTimeshift;
};

#endif // !defined(AFX_AVPLAYBACKCTRL_H__7C0F2517_B18A_47C0_8DB7_806C674FE555__INCLUDED_)
